/*
** Klib.P
**
** Hilfsroutinen zur Ansprache des Kolter-PCI-Drivers 
** ber den Winston von Pearl90 aus
** 
** Funktionsbeschreibung: s. Klib.H oder bei der jeweiligen Funktion
**
** Die Task ShowPCI zeigt die Belegung aller vorhandenen PCI-Busse an.
**
** (c) IEP GmbH Langenhagen, 2004
*/

#DEFINE THIS_IS_KLIB = 1 
#DEFINE GET_SIGNATURE = 0 ; /* 1: mit Dummy-Routinen zur Signaturbestimmung */

/*+T*/
/*+M*/

MODULE KLIB ;

SYSTEM ;
   TY: A1. ;

PROBLEM ;

   SPC TY DATION INOUT ALPHIC ;
#INCLUDE Klib.H 
#INCLUDE ../INC/SYSSBR.H 

#IF GET_SIGNATURE == 1 ;
/* Prototypen zur Bestimmung der Signatur */
/*+P*/
T_LoadDrv: PROC( psDLLname CHAR(1) IDENT ) 
           RETURNS( FIXED(31) )  ;
/*-P*/
   RETURN( 1(31) );
END; 
/*+P*/
T_FreeDrv: PROC( hLibrary FIXED(31) ) 
           RETURNS( FIXED(31) )  ;
/*-P*/
   RETURN( 1(31) );
END; 
/*+P*/
T_OpenDrv: PROC( handle FIXED(31), DriverName CHAR(1) IDENT, EntryPoint CHAR(1) IDENT  ) 
           RETURNS( FIXED(31) )  ;
/*-P*/
   RETURN( 1(31) );
END; 
/*+P*/
T_CloseDrv: PROC( handle FIXED(31) ) 
           RETURNS( FIXED(31) )  ;
/*-P*/
   RETURN( 1(31) );
END; 

/*+P*/
T_GetLastPciBus: PROC( hDrv FIXED(31) ) 
                     RETURNS( /* nBus */ FIXED(15) ) ;
/*-P*/
   RETURN( 1(15) );
END; 

/*+P*/
T_GetPciDeviceInfo: PROC( hDrv       FIXED(31),
                          nBus       FIXED(15),
                          nDevice    FIXED(15),
                          nFunction  FIXED(15),
                          PciCfg     PCI_CONFIG_0 IDENT
                        ) 
                        RETURNS( REF STRUCT[] ) ;
/*-P*/
   RETURN( PciCfg );
END; 

/*+P*/
T_GetPortByte: PROC( hDrv         FIXED(31),
                     PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */
                   ) 
                   RETURNS( /* f7_Data */ FIXED(7) ) ;
/*-P*/
   RETURN( 1(7) );
END; 

/*+P*/
T_GetPortWord: PROC( hDrv         FIXED(31),
                     PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */
                   ) 
                   RETURNS( /* f15_Data */ FIXED(15) ) ;
/*-P*/
   RETURN( 1(15) );
END; 

/*+P*/
T_GetPortLong: PROC( hDrv         FIXED(31),
                     PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */
                   ) 
                   RETURNS( /* f31_Data */ FIXED(31) ) ;
/*-P*/
   RETURN( 1(31) );
END; 

/*+P*/
T_SetPortByte: PROC( hDrv         FIXED(31),
                     PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */,
                     f7_Data      FIXED(7)
                   ) 
                   ;
/*-P*/
END; 

/*+P*/
T_SetPortWord: PROC( hDrv         FIXED(31),
                     PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */,
                     f15_Data     FIXED(15)
                   ) 
                   ;
/*-P*/
END; 

/*+P*/
T_SetPortLong: PROC( hDrv         FIXED(31),
                     PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */,
                     f31_Data     FIXED(31)
                   ) 
                   ;
/*-P*/
END; 
#FIN ;

#DEFINE INVALID_ADRESS  = -1(31) ;
#DEFINE MAX_PCI_DEVICES = 31 ;

DCL Dllname       CHAR(32)  INIT('Klibdrv.dll                     ') ;
DCL Drivername    CHAR(32)  INIT('KLIBDRV                         ') ;
DCL Entrypoint    CHAR(32)  INIT('KlibDevice0                     ') ;

Start_PCI_Driver: PROC( driver PCI_DRIVER IDENT ) 
                  RETURNS( FIXED(31) ) GLOBAL ;
   /* 
   ** Startet des PCI-Treibers
   ** Parameter: Struktur mit internen Verwaltungsdaten
   ** Rueckgabe: Handle fuer folgende Aufrufe des Treibers'1'B bei Erfolge
   **            '0'B im Fehlerfall
   */
   DCL hinstance  FIXED(31) ;
   DCL handle     FIXED(31) INIT( 0(31) ) ;
   DCL f31        FIXED(31) ;

   hinstance = LoadDrv( Dllname.CHAR(1) ) ;
   IF hinstance NE 0(31) THEN
      handle = 0(31) ;
      handle = OpenDrv( handle, Drivername.CHAR(1), Entrypoint.CHAR(1) ) ;
      IF handle == 0(31) THEN
         f31 = FreeDrv( hinstance ) ;
      ELSE
         driver.handleDll    = hinstance ;
         driver.handleDriver = handle    ;
      FIN ;
   FIN ;      
   RETURN( handle ) ;
END; /* P Start_PCI_Driver */

Stop_PCI_Driver: PROC( driver PCI_DRIVER IDENT ) 
                 GLOBAL ;
   /* 
   ** Stoppen des PCI-Treibers
   ** Parameter: driver-Struktur aus dem Aufruf von Start_PCI_Driver
   */
   DCL f31 FIXED(31) ;
   f31 = CloseDrv( driver.handleDriver ) ;
   f31 = FreeDrv( driver.handleDll ) ;
END; /* P Stop_PCI_Driver */

FindNextPCIBase: PROC( handle   FIXED(31),
                       find     PCI_FIND_STRUCT IDENT 
                     )
                  RETURNS( FIXED(31) ) GLOBAL ;
   /*
   ** Sucht auf dem PCI-Bus nach einer Karte entsprechend der
   ** Beschreibung in dem Parameter find.
   ** Wurde eine Karte gefunden, so wird die find-Struktur so
   ** geaendert, dass ein weiterer Aufruf die naechste Karte 
   ** mit identischer Beschreibung findet.
   **
   ** Zur erstmaligen Suche muss FindFirstPCIBase verwendet werden!
   ** Rueckgabe: Basisadresse der Karte
   **            -1, wenn keine entsprechende Karte gefunden wurde
   */
   DCL adresse FIXED(31)   INIT( INVALID_ADRESS ) ;
   DCL found   BIT(1)      INIT( '0'B ) ;
   /*
   ** auf naechstes Bus/Device/Funktion schalten
   */
   find.function = find.function + 1 ;
   IF find.function GT find.maxFunction THEN
      find.function = 0 ;
      find.device   = find.device + 1 ;
      IF find.device GT MAX_PCI_DEVICES THEN
         find.device = 0 ;
         find.bus    = find.bus + 1 ;
      FIN ;
   FIN ;

   FOR bus FROM find.bus TO find.maxBus WHILE NOT found
   REPEAT ;
      FOR device FROM find.device TO MAX_PCI_DEVICES WHILE NOT found
      REPEAT ;
         FOR function FROM find.function TO find.maxFunction WHILE NOT found
         REPEAT ;
            DCL pVoid            REF STRUCT[] ;
            DCL b16_configType   BIT(16) ;
            DCL nConfigType      FIXED ;
            DCL pPciConfig_0     REF PCI_CONFIG_0 ;
            DCL pPciConfig_1     REF PCI_CONFIG_1 ;
            DCL pPciConfig_2     REF PCI_CONFIG_2 ;
            pVoid = GetPciDeviceInfo( handle, bus, device, function, find.pciCfg ) ;
            IF pVoid IS NIL THEN
               find.maxFunction = 0 ; /* kein device ==> keine functions */
            ELSE
               b16_configType = TOBIT(TOFIXED(find.pciCfg.Head.HeaderType)) ;
               nConfigType    = TOFIXED( b16_configType AND '007F'B4 ) ;
               CASE nConfigType
                  ALT (0) /* Non-bridge */
                     pPciConfig_0 = pVoid ;
                     IF     (    find.vendorID EQ 'FFFF'B4 
                              OR pPciConfig_0.Head.VendorID EQ find.vendorID
                            )
                        AND (    find.deviceID EQ 'FFFF'B4
                              OR pPciConfig_0.Head.DeviceID EQ find.deviceID
                            )
                     THEN
                        found = '1'B ;
                        adresse = pPciConfig_0.Type0.BaseAddresses(1) ;
                     FIN ;
                  ALT (1) /* bridge     */
                     pPciConfig_1 = pVoid ;
                     IF     (    find.vendorID EQ 'FFFF'B4 
                              OR pPciConfig_1.Head.VendorID EQ find.vendorID
                            )
                        AND (    find.deviceID EQ 'FFFF'B4
                              OR pPciConfig_1.Head.DeviceID EQ find.deviceID
                            )
                     THEN
                        found = '1'B ;
                        adresse = pPciConfig_1.Type1.BaseAddresses(1) ;
                     FIN ;
                  ALT (2) /* Cardbus    */
                     pPciConfig_2 = pVoid ;
                     IF     (    find.vendorID EQ 'FFFF'B4 
                              OR pPciConfig_2.Head.VendorID EQ find.vendorID
                            )
                        AND (    find.deviceID EQ 'FFFF'B4
                              OR pPciConfig_2.Head.DeviceID EQ find.deviceID
                            )
                     THEN
                        found = '1'B ;
                        adresse = pPciConfig_2.Type2.Range(1).Base ;
                     FIN ;
               FIN ;
               IF find.function EQ 0 THEN
                  IF b16_configType.BIT(9) THEN
                     find.maxFunction = 7 ; /* multifunction-device      */
                  ELSE
                     find.maxFunction = 0 ; /* kein multifunction-device */
                  FIN ;
               FIN ;
            FIN ;
            IF found THEN
               find.function = function ;
            FIN ;
         END; /* ueber alle fuctions eines devices */
         IF found THEN
            find.device = device ;
         ELSE
            find.function = 0 ;
         FIN ;
      END; /* ueber alle devices an einem Bus */
      IF found THEN
         find.bus = bus ;
      ELSE
         find.device = 0 ;
      FIN ;
   END; /* ueber alle Busse */

   RETURN( adresse ) ;
END; /* P FindNextPCIBase */

FindFirstPCIBase: PROC( handle   FIXED(31),
                        VendorID BIT(16), 
                        DeviceID BIT(16), 
                        find     PCI_FIND_STRUCT IDENT 
                      )
                  RETURNS( FIXED(31) ) GLOBAL ;
   /*
   ** Startet die Suche auf dem PCI-Bus nach einer Karte mit vorgegebener 
   ** Vendor- und Device-ID, 'FFFF'B4 findet jeweils alle IDs.
   ** Weitere identische Karten knnen durch folgende Aufrufe von
   ** FindNextPCIBase gefunden werden.
   ** Rueckgabe: Basisadresse der Karte
   **            0, wenn keine entsprechende Karte gefunden wurde
   */
   find.vendorID    = VendorID ;
   find.deviceID    = DeviceID ;
   find.bus         = -1 ;
   find.device      = MAX_PCI_DEVICES ;
   find.function    = 0 ;
   find.maxFunction = 0 ;
   find.maxBus      = GetLastPciBus( handle ) ;

   RETURN( FindNextPCIBase( handle, find ) ) ;

END; /* P FindFirstPCIBase */

ShowPCI: TASK ;
   DCL handle     FIXED(31) ;
   DCL driver     PCI_DRIVER ;
   DCL find       PCI_FIND_STRUCT ;
   DCL adresse    FIXED(31) ;

   CALL ASSIGN( TY, 'TY' ) ;
   handle = Start_PCI_Driver( driver ) ;
   IF handle EQ 0(31) THEN
      PUT 'ShowPCI: Treiber kann nicht gestartet werden' TO TY BY SKIP,A;
   ELSE
      adresse = FindFirstPCIBase( handle, 'FFFF'B4, 'FFFF'B4, find ) ;
      PUT 'Bus Device Function VID  DID  Typ' TO TY BY SKIP,A;
      WHILE adresse NE INVALID_ADRESS REPEAT ;
         DCL pVoid            REF STRUCT[] ;
         DCL b16_configType   BIT(16) ;
         DCL nConfigType      FIXED ;
         DCL pPciConfig_0     REF PCI_CONFIG_0 ;
         DCL pPciConfig_1     REF PCI_CONFIG_1 ;
         DCL pPciConfig_2     REF PCI_CONFIG_2 ;
         pVoid = find.pciCfg ;
         b16_configType = TOBIT(TOFIXED(find.pciCfg.Head.HeaderType)) ;
         nConfigType = TOFIXED( b16_configType AND '007F'B4 ) ;
         PUT find.bus, find.device, find.function TO TY BY SKIP,F(3),X,F(3),X(4),F(3),X(6) ;
         CASE nConfigType
            ALT (0) /* Non-bridge */
               pPciConfig_0 = pVoid ;
               PUT pPciConfig_0.Head.VendorID, pPciConfig_0.Head.DeviceID, 'Non-Bridge         ', 
                  '@ ',TOBIT(pPciConfig_0.Type0.BaseAddresses(1))
                  TO TY BY B4,X,B4,X,A,A,B4 ;
            ALT (1) /* bridge     */
               pPciConfig_1 = pVoid ;
               PUT pPciConfig_1.Head.VendorID, pPciConfig_1.Head.DeviceID, 'PCI-PCI Bridge     ', 
                  '@ ',TOBIT(pPciConfig_1.Type1.BaseAddresses(1))
                  TO TY BY B4,X,B4,X,A,A,B4 ;
            ALT (2) /* Cardbus    */
               pPciConfig_2 = pVoid ;
               PUT pPciConfig_2.Head.VendorID, pPciConfig_2.Head.DeviceID, 'PCI-Cardbus Bridge ', 
                  '@ ',TOBIT(pPciConfig_2.Type2.Range(1).Base)
                  TO TY BY B4,X,B4,X,A,A,B4 ;
            OUT
               PUT nConfigType TO TY BY X(10),F(4);
         FIN ;
         adresse = FindNextPCIBase( handle, find ) ;
      END ;
      Stop_PCI_Driver( driver ) ;
   FIN ;

   PUT 'Done: ', GET_TASKNAME() TO TY BY SKIP,A,A;

END; /* T ShowPCI */   

MODEND ;