/*
**  Pearl90-Interface zur Ansprache des Kolter-PCI-Drivers
**
**  Spezifikation der PEARL90-Routinen aus KlibDrv.A68
*/

#IFUDEF KLIBDRV_H_INCLUDED 
   #DEFINE KLIBDRV_H_INCLUDED = 1 

   /*
   ** Datentypen fuer die PCI-Konfigurationsdaten
   */
   #DEFINE PCI_TYPE0_ADDRESSES = 6 ; /* non-Bridge              */
   #DEFINE PCI_TYPE1_ADDRESSES = 2 ; /* PCI to PCI Bridge       */
   #DEFINE PCI_TYPE2_ADDRESSES = 5 ; /* PCI to Cardbus Bridge   */


   TYPE PCI_COMMON_CONFIG_HEAD STRUCT [

      VendorID       BIT(16),    ! (ro)
      DeviceID       BIT(16),    ! (ro)
      Command        FIXED(15),  ! Device control
      Status         FIXED(15),
      RevisionID     CHAR(1),    ! (ro)
      ProgIf         CHAR(1),    ! (ro)
      SubClass       CHAR(1),    ! (ro)
      BaseClass      CHAR(1),    ! (ro)
      CacheLineSize  CHAR(1),    ! (ro+)
      LatencyTimer   CHAR(1),    ! (ro+)
      HeaderType     CHAR(1),    ! (ro)
      BIST           CHAR(1)     ! Built in self test
   ] ; /* 16 Byte */
   
   TYPE PCI_HEADER_TYPE_0 STRUCT [
		/*
      ** Non - Bridge
      */
      BaseAddresses(PCI_TYPE0_ADDRESSES) FIXED(31),
      CIS                                FIXED(31), ! CardBus_CIS 
      SubVendorID                        FIXED(15),
      SubSystemID                        FIXED(15),
      ROMBaseAddress                     FIXED(31),
      CapabilitiesPtr                    CHAR(1),
      Reserved1(3)                       CHAR(1),
      Reserved2                          FIXED(31),

      InterruptLine                      CHAR(1),
      InterruptPin                       CHAR(1),   ! (ro)
      MinimumGrant                       CHAR(1),   ! (ro)
      MaximumLatency                     CHAR(1)    ! (ro)
   ] ; /* 46 Byte */

   TYPE PCI_HEADER_TYPE_1 STRUCT [
      /*
      ** PCI to PCI Bridge
      */
      BaseAddresses(PCI_TYPE1_ADDRESSES)   FIXED(31),
      PrimaryBus                           CHAR(1),
      SecondaryBus                         CHAR(1),
      SubordinateBus                       CHAR(1),
      SecondaryLatency                     CHAR(1),
      IOBase                               CHAR(1),
      IOLimit                              CHAR(1),
      SecondaryStatus                      FIXED(15),
      MemoryBase                           FIXED(15),
      MemoryLimit                          FIXED(15),
      PrefetchBase                         FIXED(15),
      PrefetchLimit                        FIXED(15),
      PrefetchBaseUpper32                  FIXED(31),
      PrefetchLimitUpper32                 FIXED(31),
      IOBaseUpper16                        FIXED(15),
      IOLimitUpper16                       FIXED(15),
      CapabilitiesPtr                      CHAR(1),
      Reserved1(3)                         CHAR(1),
      ROMBaseAddress                       FIXED(31),
      InterruptLine                        CHAR(1),
      InterruptPin                         CHAR(1),
      BridgeControl                        FIXED(15)
   ] ; /* 46 Byte */

   TYPE PCI_RANGE STRUCT [
      Base  FIXED(31),
      Limit FIXED(31)
   ] ; /* 8 Byte */

   TYPE PCI_HEADER_TYPE_2 STRUCT [
      /*
      ** PCI to CARDBUS Bridge
      */

      SocketRegistersBase /*Address */    FIXED(31), 
      CapabilitiesPtr                CHAR(1),
      Reserved                       CHAR(1),
      SecondaryStatus                FIXED(15),
      PrimaryBus                     CHAR(1),
      SecondaryBus                   CHAR(1),
      SubordinateBus                 CHAR(1),
      SecondaryLatency               CHAR(1),
      Range( PCI_TYPE2_ADDRESSES-1)  PCI_RANGE,
      InterruptLine                  CHAR(1),
      InterruptPin                   CHAR(1),
      BridgeControl                  FIXED(15)
   ] ; /* 48 Byte */


   TYPE PCI_CONFIG_0 STRUCT [
      Head           PCI_COMMON_CONFIG_HEAD,
      Type0          PCI_HEADER_TYPE_0,
      Dummy          FIXED(15),
      DeviceSpecific CHAR(192)
   ] ;

   TYPE PCI_CONFIG_1 STRUCT [
      Head           PCI_COMMON_CONFIG_HEAD,
      Type1          PCI_HEADER_TYPE_1,
      Dummy          FIXED(15),
      DeviceSpecific CHAR(192)
   ] ;
   
   TYPE PCI_CONFIG_2 STRUCT [
      Head           PCI_COMMON_CONFIG_HEAD,
      Type2          PCI_HEADER_TYPE_2,
      DeviceSpecific CHAR(192)
   ] ;

   /*
   ** Laden der Treiber-DLL
   ** Jeder Aufruf von LoadDrv erfordert einen korrespondierenden Aufruf von FreeDrv
   ** In:        Name der zu ladenden DLL
   ** Rueckgabe: HINSTANCE der geladenen DLL
   **            0 im Fehlerfall
   */
   SPC LoadDrv    ENTRY( psDLLname CHAR(1) IDENT ) 
                         RETURNS( /* hLibrary */ FIXED(31) ) GLOBAL ;

   /*
   ** Entladen der Treiber-DLL
   ** Jeder Aufruf von LoadDrv erfordert einen korrespondierenden Aufruf von FreeDrv
   ** In:         HINSTANCE aus dem LoadDrv-Aufruf
   ** Rueckgabe:  0 im Fehlerfall
   */
   SPC FreeDrv    ENTRY( HINSTANCE FIXED(31) ) 
                         RETURNS( FIXED(31) ) GLOBAL ;

   /*
   ** Starten des Treibers
   ** Jeder Aufruf von OpenDrv erfordert einen korrespondierenden Aufruf von CloseDrv
   ** In:         handle      (muss == 0 beim ersten Aufruf)
   **             DriverName, z.B. "TVICHW32" fuer den Kolter-PCI-Treiber
   **             EntryPoint, "TVicDevice0" oder "TVicDevice1" fuer den Kolter-PCI-Treiber
   ** Rueckgabe:  Handle des Treibers
   **             0 im Fehlerfall
   */
   SPC OpenDrv    ENTRY( handle     FIXED(31), /* 0 beim ersten Aufruf */
                         DriverName CHAR(1) IDENT, 
                         EntryPoint CHAR(1) IDENT 
                       ) RETURNS( /* hDrv */ FIXED(31) ) GLOBAL ;

   /*
   ** Stoppen des Treibers
   ** Jeder Aufruf von OpenDrv erfordert einen korrespondierenden Aufruf von CloseDrv
   ** In:         hDrv aus OpenDrv
   ** Rueckgabe:  0 
   */
   SPC CloseDrv   ENTRY( hDrv FIXED(31) ) 
                         RETURNS( /* hDrv */ FIXED(31) ) GLOBAL ;


   /*
   ** PCI-Konfiguration: Lesen der Anzahl der vorhandenen PCI-Busse
   ** In:         hDrv aus OpenDrv
   ** Rueckgabe:  Anzahl der Busse
   */
   SPC GetLastPciBus ENTRY( hDrv FIXED(31) ) 
                            RETURNS( /* nBus */ FIXED(15) ) GLOBAL ;


   /*
   ** PCI-Konfiguration: Lesen der Konfiguration eines PCI-Geraetes
   ** In:         hDrv:       aus OpenDrv
   **             nBus:       Nummer des angesprochenen PCI-Busses
   **             nDevice:    Nummer des angesprochenen Devices auf nBus
   **             nFunction:  Nummer der angesprochenen Funktion im Device
   **                         (Vorsicht! Nur 0 ist bei allen Devices erlaubt!)
   **             PciCfg:    Speicherplatz fr die ausgelesene Information
   ** Rueckgabe:  Zeiger auf ausgefllte PciCfg 
   **             NIL:        das Geraet existiert nicht
   */
   SPC GetPciDeviceInfo ENTRY( hDrv       FIXED(31),
                               nBus       FIXED(15),
                               nDevice    FIXED(15),
                               nFunction  FIXED(15),
                               PciCfg     PCI_CONFIG_0 IDENT
                             ) 
                             RETURNS( REF STRUCT[] ) GLOBAL ;
   
   /*
   ** PCI-I/O: Lesen eines Bytes von einer Portadresse
   ** In:         hDrv aus OpenDrv
   **             PortAdresse in Big-Endian bzw. Motorola-Notation
   ** Rueckgabe:  gelesenes Datum
   */
   SPC GetPortByte ENTRY( hDrv         FIXED(31),
                          PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */
                        ) 
                        RETURNS( /* f7_Data */ FIXED(7) ) GLOBAL ;

   /*
   ** PCI-I/O: Lesen eines Wortes von einer Portadresse
   ** In:         hDrv aus OpenDrv
   **             PortAdresse in Big-Endian bzw. Motorola-Notation
   ** Rueckgabe:  gelesenes Datum
   */
   SPC GetPortWord ENTRY( hDrv         FIXED(31),
                          PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */
                        ) 
                        RETURNS( /* f15_Data */ FIXED(15) ) GLOBAL ;

   /*
   ** PCI-I/O: Lesen eines Langwortes von einer Portadresse
   ** In:         hDrv aus OpenDrv
   **             PortAdresse in Big-Endian bzw. Motorola-Notation
   ** Rueckgabe:  gelesenes Datum
   */
   SPC GetPortLong ENTRY( hDrv         FIXED(31),
                          PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */
                        ) 
                        RETURNS( /* f31_Data */ FIXED(31) ) GLOBAL ;

   /*
   ** PCI-I/O: Schreiben eines Bytes an eine Portadresse
   ** In:         hDrv aus OpenDrv
   **             PortAdresse in Big-Endian bzw. Motorola-Notation
   **             f7_datum: auszugebender Wert
   ** Rueckgabe:  -
   */
   SPC SetPortByte ENTRY( hDrv         FIXED(31),
                          PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */,
                          f7_Data      FIXED(7)
                        ) 
                        GLOBAL ;

   /*
   ** PCI-I/O: Schreiben eines Bytes an eine Portadresse
   ** In:         hDrv aus OpenDrv
   **             PortAdresse in Big-Endian bzw. Motorola-Notation
   **             f15_datum: auszugebender Wert
   ** Rueckgabe:  -
   */
   SPC SetPortWord ENTRY( hDrv         FIXED(31),
                          PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */,
                          f15_Data     FIXED(15)
                        ) 
                        GLOBAL ;

   /*
   ** PCI-I/O: Schreiben eines Bytes an eine Portadresse
   ** In:         hDrv aus OpenDrv
   **             PortAdresse in Big-Endian bzw. Motorola-Notation
   **             f7_datum: auszugebender Wert
   ** Rueckgabe:  -
   */
   SPC SetPortLong ENTRY( hDrv         FIXED(31),
                          PortAdresse  FIXED(31) /* Big-Endian / Motorola-Notation */,
                          f31_Data     FIXED(31)
                        ) 
                        GLOBAL ;

#FIN ; /* KLIBDRV_H_INCLUDED */
