#IFUDEF KLIB_H_INCLUDED 
   #DEFINE KLIB_H_INCLUDED = 1 

/*
** Definitionen und Spezifikation der Hilfsroutinen aus Klib.P
*/

#INCLUDE KlibDrv.H

   TYPE PCI_DRIVER STRUCT [
      handleDll      FIXED(31) ,
      handleDriver   FIXED(31) 
   ] ;

   TYPE PCI_FIND_STRUCT STRUCT [ 
      vendorID    BIT(16) ,
      deviceID    BIT(16) ,
      maxBus      FIXED ,  /* Anzahl der PCI-Busse       */
      maxFunction FIXED ,  /* Fuer Multifunktionskarten  */
      bus         FIXED ,
      device      FIXED ,
      function    FIXED ,
      pciCfg      PCI_CONFIG_0
   ] ;
  
/* 
** Startet des PCI-Treibers
** Parameter: Struktur mit internen Verwaltungsdaten
** Rueckgabe: Handle fuer folgende Aufrufe des Treibers'1'B bei Erfolge
**            0 im Fehlerfall
*/
#IFDEF THIS_IS_KLIB ;
   SPC Start_PCI_Driver ENTRY( driver PCI_DRIVER IDENT ) 
                        RETURNS( FIXED(31) ) 
                        ;
#ELSE ;
    SPC Start_PCI_Driver ENTRY( driver PCI_DRIVER IDENT ) 
                         RETURNS( FIXED(31) ) 
                         GLOBAL ;
#FIN ;

/* 
** Stoppen des PCI-Treibers
** Parameter: driver-Struktur aus dem Aufruf von Start_PCI_Driver
*/
#IFDEF THIS_IS_KLIB ;
   SPC Stop_PCI_Driver ENTRY( driver PCI_DRIVER IDENT ) 
                       ;
#ELSE ;
   SPC Stop_PCI_Driver ENTRY( driver PCI_DRIVER IDENT ) 
                       GLOBAL ;
#FIN ;

/*
** Sucht auf dem PCI-Bus nach einer Karte entsprechend der
** Beschreibung in dem Parameter find.
** Wurde eine Karte gefunden, so wird die find-Struktur so
** geaendert, dass ein weiterer Aufruf die naechste Karte 
** mit identischer Beschreibung findet.
**
** Zur erstmaligen Suche muss FindFirstPCIBase verwendet werden!
** Rueckgabe: Basisadresse der Karte
**            -1, wenn keine entsprechende Karte gefunden wurde
*/
#IFDEF THIS_IS_KLIB ;
   SPC FindNextPCIBase ENTRY( handle   FIXED(31),
                              find     PCI_FIND_STRUCT IDENT 
                            )
                       RETURNS( FIXED(31) ) 
                       ;
#ELSE ;
   SPC FindNextPCIBase ENTRY( handle   FIXED(31),
                              find     PCI_FIND_STRUCT IDENT 
                            )
                       RETURNS( FIXED(31) ) 
                       GLOBAL ;
#FIN ;

/*
** Startet die Suche auf dem PCI-Bus nach einer Karte mit vorgegebener 
** Vendor- und Device-ID, 'FFFF'B4 findet jeweils alle IDs.
** Weitere identische Karten knnen durch folgende Aufrufe von
** FindNextPCIBase gefunden werden.
** Rueckgabe: Basisadresse der Karte
**            0, wenn keine entsprechende Karte gefunden wurde
*/
#IFDEF THIS_IS_KLIB ;
   SPC FindFirstPCIBase ENTRY( handle   FIXED(31),
                               VendorID BIT(16), 
                               DeviceID BIT(16), 
                               find     PCI_FIND_STRUCT IDENT 
                             )
                        RETURNS( FIXED(31) ) 
                        ;
#ELSE ;
   SPC FindFirstPCIBase ENTRY( handle   FIXED(31),
                               VendorID BIT(16), 
                               DeviceID BIT(16), 
                               find     PCI_FIND_STRUCT IDENT 
                             )
                        RETURNS( FIXED(31) ) 
                        GLOBAL ;
#FIN ;

/*
** Task zur Ausgabe der Belegung des PCI-Busses
*/
#IFDEF THIS_IS_KLIB ;
   SPC ShowPCI TASK 
      ;
#ELSE ;
   SPC ShowPCI TASK 
      GLOBAL ;
#FIN ;

#FIN ; /* KLIB_H_INCLUDED */ 